<?php
require_once 'Cache/Lite.php';

$opts = array(
   // Lokalizacja pliku bufora danych
   'cacheDir' => '/tmp',
   // Umoliwienie przechowywania tablic w buforze
  'automaticSerialization' => true,
  // Czas przechowywania danych w buforze
  'lifeTime' => 600 /* dziesic minut */);              

// Utworzenie bufora 
$cache = new Cache_Lite($opts);

// Poczenie z baz danych
$db = new PDO('sqlite:/usr/local/zodiac.db');

// Zdefiniowanie zapytania i jego parametrw
$sql = 'SELECT * FROM zodiac WHERE planet = ?';
$params = array($_GET['planet']);

// Wyznaczenie unikatowego klucza bufora
$key = cache_key($sql, $params);

// Prba pobrania danych z bufora
$results = $cache->get($key);

if ($results === false) {
    // Brak danych. Trzeba wykona zapytanie i umieci jego wynik w buforze
    $st = $db->prepare($sql);
    $st->execute($params);
    $results = $st->fetchAll();
    $cache->save($results);
}

// Zmienna $results przechowuje wynik, niezalenie od tego, czy zosta on pobrany z
// bufora, czy nie
foreach ($results as $result) {
    print "$result[id]: $result[planet], $result[sign] <br/>\n";
}
    
function cache_key($sql, $params) {
    return md5($sql .
               implode('|',array_keys($params)) .
               implode('|',$params));
}
?>
